<div class="modal-content" id="showCustomer">
    <?php
        $avatar = asset('/dist/img/avatar5.png');
        if (trim($customer->avatar) != 'no-foto.png') {
            $avatar = $customer->fileUrl();
        }
    ?>
    <section class="content-header">
      <h1><button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
          <?php echo e(__('Customer Profile')); ?></h1>
    </section>
      
      <!-- Main content -->
    <section class="content">
      <?php echo $__env->make('partials.flash', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <div class="row">
          <div class="col-md-3">
            <!-- Profile Image -->
            <div class="box box-success">
              <div class="box-body box-profile">
                <img class="profile-user-img img-responsive img-circle" src="<?php echo e($avatar); ?>" alt="User profile picture">
                <h3 class="profile-username text-center"><?php echo e($customer->name); ?></h3>
                <ul class="list-group list-group-unbordered">
                  <li class="list-group-item">
                    <b><?php echo e(__('Balance')); ?> </b> <a class="pull-right"><?php echo e(currencySymbol().$customer->prev_balance); ?></a>
                  </li>
                  <li class="list-group-item hidden-print">
                    <b><?php echo e(__('Total Sales')); ?> </b> <a class="pull-right"><?php echo e($total_sales); ?></a>
                  </li>
                </ul>
                <a class="btn btn-success btn-block hidden-print" href="#" data-toggle="modal" data-target="#customerPaymentModal"><b><?php echo e(__('Add Payment')); ?></b></a>
                <!--Customer Payment Modal start-->
                <div class="modal submodal fade" id="customerPaymentModal" role="dialog">
                  <div class="modal-dialog modal-sm">
                    <div class="modal-content">
                      <div class="modal-header">
                        <button type="button" class="close" onclick="closeEl('.submodal', '#customerPaymentModal')">&times;</button>
                        <h4 class="modal-title"><?php echo e(__('Add Payment')); ?></h4>
                      </div>
                      <div class="modal-body">
                        <?php echo e(Form::open(['route'=>'customerpayments.store'])); ?>

                          <div class="form-group">
                              <?php echo e(Form::select('payment_type', $payment_types, null, array('class' => 'form-control','placeholder'=>'Select payment type','required'))); ?>

                          </div>
                          <div class="form-group"><!---select account input-->
                              <?php echo e(Form::select('account_id', $accounts, null, ['class'=>'form-control', 'placeholder'=>'Select Account', 'required'])); ?>

                          </div>
                          <div class="form-group">
                            <?php echo e(Form::hidden('customer_id', $customer->id, ['class'=>'form-control'])); ?>

                            <?php echo e(Form::number('payment', null, ['class'=>'form-control', 'placeholder'=>'Amount', 'required'])); ?>

                          </div>
                          <div class="form-group">
                            <?php echo e(Form::text('comments', null, ['class'=>'form-control','placeholder'=>'Comments'])); ?>

                          </div>
                          <div class="form-group">
                            <?php echo e(Form::submit('Add Payment', ['class'=>'btn btn-success', 'onclick'=>"$('.modal-backdrop').remove()"])); ?>

                          </div>
                        <?php echo e(Form::close()); ?>

                      </div>
                      <div class="modal-footer">
                        <button type="button" class="btn btn-success" onclick="closeEl('.submodal', '#customerPaymentModal')"><?php echo e(__('Close')); ?></button>
                      </div>
                    </div>
                  </div>
                </div><!--Customer Payment Modal End-->

              </div>
              <!-- /.box-body -->
            </div>
            <!-- /.box -->
            
           <!-- About Me Box -->
            <div class="box box-success">
              <div class="box-header with-border">
                <h3 class="box-title"><?php echo e(__('Last Payment History')); ?></h3>
              </div>
              <!-- /.box-header -->
              <div class="box-body p-0">
                <table class="table table-hover table-striped">
                  <thead>
                    <tr>
                      <th><?php echo e(__('Date')); ?></th>
                      <th><?php echo e(__('Payment')); ?></th>
                    </tr>
                  </thead>
                  <tbody>
                    <?php $__currentLoopData = $customer_payments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $customer_payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                      <td><?php echo e($customer_payment->created_at->format('M d')); ?></td>
                      <td><?php echo e(currencySymbol().$customer_payment->payment); ?></td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                      <td colspan="3" style="background: #00a65a;padding: 2px;"></td>
                    </tr>
                    <?php $__currentLoopData = $sale_payments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sale_payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                      <td><?php echo e($sale_payment->created_at->format('M d')); ?></td>
                      <td><?php echo e(currencySymbol().$sale_payment->payment); ?></td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                  </tbody>
                </table>
              </div>
              <!-- /.box-body -->
            </div>
            <!-- /.box -->
      
          </div>
          <!-- /.col -->
          <div class="col-md-9">
            <h3 class="mt-0">All Sales</h3>
            <?php echo $__env->make('customer.partials.sale_table', ['salereport'=>$sales, 'type'=>'customer'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <!-- /.nav-tabs-custom -->
          </div>
          <!-- /.col -->
        </div>
        <!-- /.row -->
    </section>
</div><?php /**PATH /Users/ajitdas/prjs-mega/flexiblepos-v2.0/resources/views/customer/profile.blade.php ENDPATH**/ ?>