<div class="col-md-12" id="daily_report_table">
    <h4 class="text-center"> <?php echo e(__('Date')); ?> : <?php echo e(!empty($date) ? $date : \Carbon\Carbon::today()->format('Y-m-d')); ?></h4>
    <?php if(count($daily_sales) || count($customer_payments) || count($receiving_payments) || count($expenses) || count($supplier_payments) ): ?>
    <form action="<?php echo e($action == 'edit' ? route('dailyreport.update', $exist_report->id) : url('reports/dailyreport')); ?>" method="POST" id="close_daily_report" class="close-daily-report">
        <?php echo csrf_field(); ?>
        <input type="hidden" name="date" value="<?php echo e(!empty($date) ? $date : \Carbon\Carbon::today()->format('Y-m-d')); ?>">
        <table class="table table-bordered table-striped table-hover">
            <thead>
                <tr>
                    <th><?php echo e(__('Income Source')); ?></th>
                    <th><?php echo e(__('Expense Source')); ?></th>
                    <th><?php echo e(__('Credit')); ?></th>
                    <th><?php echo e(__('Debit')); ?></th>
                    <th><?php echo e(__('Balance')); ?></th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td><?php echo e(__('Previous Balance')); ?></td>
                    <td></td>
                    <td></td>
                    <td></td>
                    <td>
                        <?php if(empty($exist_report)): ?>
                        <?php echo e(currencySymbol()); ?><input type="number" class="hidden-input" name="prev_balance" value="<?php echo e($starting_balance); ?>">
                        <?php else: ?>
                            <?php if($action == 'edit'): ?>
                            <?php echo e(currencySymbol()); ?><input type="number" class="hidden-input" name="prev_balance" value="<?php echo e($exist_report->prev_balance); ?>">
                            <?php else: ?>
                            <?php echo e(currencySymbol().$starting_balance = $exist_report->prev_balance); ?>

                            <?php endif; ?>
                        <?php endif; ?>
                    </td>
                </tr>
            
            <?php $__currentLoopData = $daily_sales; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $daily_sale): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php if($daily_sale->payment > '0.00' ): ?>
                <tr>
                    <td>Sales: <?php echo e($daily_sale->sale->customer->name); ?></td>
                    <td></td>
                    <td><?php echo e(currencySymbol().$daily_sale->payment); ?></td>
                    <td></td>
                    <td></td>
                </tr>
                <?php elseif($daily_sale->comments == 'REFUND'): ?>
                <tr>
                    <td>Refund Sales: <?php echo e($daily_sale->sale->customer->name); ?></td>
                    <td></td>
                    <td><?php echo e(currencySymbol().$daily_sale->payment); ?></td>
                    <td></td>
                    <td></td>
                </tr>
                <?php endif; ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        
            
            <?php $__currentLoopData = $customer_payments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $customer_payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php if($customer_payment->payment > '0.00'): ?>
                <tr>
                    <td>Customer:<?php echo e($customer_payment->customer->name); ?></td>
                    <td></td>
                    <td><?php echo e(currencySymbol().number_format($customer_payment->payment)); ?></td>
                    <td></td>
                    <td></td>
                </tr>
                <?php endif; ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            
            <?php $__currentLoopData = $receiving_payments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $receiving_payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php if($receiving_payment->payment > '0.00'): ?>
                <tr>
                    <td></td>
                    <td>Purchases: <?php echo e($receiving_payment->receiving->supplier->name); ?></td>
                    <td></td>
                    <td><?php echo e(currencySymbol().number_format($receiving_payment->payment)); ?></td>
                    <td></td>
                </tr>
                <?php endif; ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            
            <?php $__currentLoopData = $supplier_payments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $supplier_payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php if($supplier_payment->payment > '0.00'): ?>
                <tr>
                    <td></td>
                    <td>Suppliers: <?php echo e($supplier_payment->supplier->name); ?></td>
                    <td></td>
                    <td><?php echo e(currencySymbol().number_format($supplier_payment->payment)); ?></td>
                    <td></td>
                </tr>
                <?php endif; ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            
            <?php $__currentLoopData = $expenses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $expense): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php if($expense->payment > '0.00'): ?>
                <tr>
                    <td></td>
                    <td><?php echo e($expense->expense_category->name . " : " .$expense->description); ?></td>
                    <td></td>
                    <td><?php echo e(currencySymbol().number_format($expense->payment)); ?></td>
                    <td></td>
                </tr>
                <?php endif; ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td><strong><?php echo e(__('Total')); ?></strong></td>
                <td></td>
                <td><strong><?php echo e(currencySymbol().number_format( $total_credit, 2)); ?></strong></td>
                <td><strong><?php echo e(currencySymbol().number_format($total_debit, 2)); ?></strong></td>
                <td><strong><?php echo e(currencySymbol().number_format($starting_balance + $total_credit - $total_debit, 2)); ?>

                </strong></td>
            </tr>
            </tbody>
        </table>
        </form>
        <?php if(empty($dailyreport) || is_null($exist_report)): ?>
            <button class="hidden-print btn btn-success pull-right" onclick="submitWithConfirm('#close_daily_report','Are you Sure You want to close the report!')"><?php echo e(__('Close Report')); ?> </button>
        <?php elseif(!empty($exist_report) && $action == 'edit'): ?>
            <button class="hidden-print btn btn-warning pull-right" onclick="submitWithConfirm('#close_daily_report', 'Are you Sure You want to update the report!')"><?php echo e(__('Update Report')); ?> </button>
        <?php endif; ?>
    <?php else: ?>
        <h3 class="alert alert-warning text-center"><?php echo e(__('No reports Available')); ?></h3>
    <?php endif; ?>
</div><?php /**PATH /Users/ajitdas/prjs-mega/flexiblepos-v2.0/resources/views/report/daily_report_table.blade.php ENDPATH**/ ?>