<?php if(!empty($expense)): ?>
<div class="modal-content" id="editExpense"  >
    <?php echo e(Form::model($expense, array('route' => array('expense.update', $expense->id), 'method' => 'PUT', 'files' => true,))); ?>

<?php else: ?>
<div class="modal-content" id="addExpense">
    <?php echo e(Form::open(array('url' => 'expense', 'files' => true,))); ?>

<?php endif; ?>
<div class="modal-header">
    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
    <h4 class="modal-title"><?php if(!empty($expense)): ?> <?php echo e(__('Edit Expense')); ?> <?php else: ?> <?php echo e(__('Add Expense')); ?><?php endif; ?></h4>
</div>
<div class="modal-body" >
    <div class="row">
        <div class="col-md-6" >
            <?php echo $__env->make('expense.add_category_btn', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <div class="form-group row">
                <?php echo e(Form::label('description', __('Description') .' *',['class'=>'col-sm-3 text-right'])); ?>

                <div class="col-sm-9"> 
                    <?php echo e(Form::text('description', null, array('class' => 'form-control', 'required'))); ?>

                </div>
            </div>

            <div class="form-group row">
                <?php echo e(Form::label('account_id', __('Select Account'),['class'=>'col-sm-3 text-right'])); ?>

                <div class="col-sm-9">
                    <?php echo e(Form::select('account_id', $accounts, null, ['class'=>'form-control'])); ?>

                </div>
            </div>
        </div>
        <div class="col-sm-6">
            <div class="form-group row">
                <?php echo e(Form::label('type', __('Payment Type'),['class'=>'col-sm-3 text-right'])); ?>

                <div class="col-sm-9"> 
                <?php echo e(Form::select('payment_type', $payment_types, null, array('class' => 'form-control'))); ?>

                </div>
            </div>
            <div class="form-group row">
                <?php echo e(Form::label('unit_price', __('Amount'), ['class'=>'col-sm-3 text-right'])); ?>

                <div class="col-sm-9">
                    <?php echo e(Form::number('unit_price', null, array('class' => 'form-control', 'id'=>'unit_price'))); ?>

                </div>
            </div>
        </div>
    </div>
</div>
<div class="modal-footer">
    <?php echo e(Form::submit(trans('supplier.submit'), array('class' => 'btn btn-success'))); ?>

    <button type="button" class="btn btn-default" data-dismiss="modal"><?php echo e(__('Close')); ?></button>
</div>
<?php echo e(Form::close()); ?>


</div><?php /**PATH /Users/ajitdas/prjs-mega/flexiblepos-v2.0/resources/views/expense/form.blade.php ENDPATH**/ ?>