<div class="box box-success" id="paymentTypeTable">
    <div class="box-header">
        <div class="row">
            <div class="col-md-6">
                <h3 class="box-title"><?php echo e(__('Payment Types')); ?></h3>
            </div>
            <div class="col-md-6">
                <form class="form-inline" action="<?php echo e(route('flexiblepossetting.payment_type')); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <div class="form-group">
                      <label for="name">Payment Type:</label>
                      <input type="text" placeholder="Payment Type Name" class="form-control" id="name" name="name">
                    </div>
                    <button type="submit" class="btn btn-success">Add Payment Type</button>
                  </form>
            </div>
        </div>
    </div>
    <div class="box-body">
        <table class="table">
            <thead>
            <tr>
                <th>Sl</th>
                <th>Payment Types</th>
            </tr>
            </thead>
            <tbody>
            <?php $__currentLoopData = $payment_types; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                <td><?php echo e($type->id); ?></td>
                <td><?php echo e($type->name); ?></td>
                <td><?php echo e($type->status==1 ? 'Active' : 'Inactive'); ?></td>
                <?php if($type->status): ?>
                <td class="p-1"><a class="btn btn-sm btn-warning" href="javascript:;" data-ajax-url="<?php echo e(route('flexiblepossetting.payment_type.update', $type->id)); ?>"><?php echo e(__('Make Inactive')); ?></a></td>
                <?php else: ?>
                <td class="p-1"><a class="btn btn-sm btn-info" href="javascript:;" data-ajax-url="<?php echo e(route('flexiblepossetting.payment_type.update', $type->id)); ?>"><?php echo e(__('Make Active')); ?></a></td>
                <?php endif; ?>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div>
  </div><?php /**PATH /Users/ajitdas/prjs-mega/flexibleps-5.6/resources/views/flexiblepos-setting/payment_type.blade.php ENDPATH**/ ?>