<section class="content panel print-content" id="saleContent">
    <div class="invoice-top-header">
        <div class="row">
            <div class="col-md-3 col-sm-3 col-xs-3 pr-0 bottom_border text-left">
                <div class="sale-logo">
                    <?php if(!empty(setting('logo_path'))): ?>
                    <img src="<?php echo e(asset(\Storage::url(setting('logo_path')))); ?>" alt="logo" >
                    <?php else: ?>
                    <img src="<?php echo e(asset('images/fpos.png')); ?>" alt="logo">
                    <?php endif; ?> 
                </div>
            </div>
            <div class="col-md-6 col-sm-6 col-xs-7 p-0 bottom_border text-center ">
                <?php if(!empty(setting('logo_path'))): ?>
                    <h1 class="company-name"><?php echo e(setting('company_name')); ?></h1>
                <?php else: ?>
                <strong><?php echo e(__('FLEXIBLEPOS')); ?></strong><br>
                <?php endif; ?> 
                
                <?php if(!empty(setting('company_address'))): ?>
                    <?php echo e(setting('company_address')); ?><br>
                <?php else: ?>
                <?php echo e(__('A reliable Company for your Business Software')); ?><br>
                <?php echo e(__('PHONE')); ?> : 01333243243266<br>
                <?php echo e(__('Chandgaon R/A,')); ?><br>
                <?php echo e(__('Chandgaon, Chittagong, Bangladesh.')); ?>

                <?php endif; ?> 
            </div>
            <div class="col-md-3 col-sm-3 col-xs-2"></div>
        </div>
    </div>
    <div class="row header-border margin-bottom-15"></div>
    <div class="row bottom_border sale-heading-info">
        <div class="col-md-7 col-sm-7 col-xs-6 text-left">
            <?php echo e(trans('sale.customer')); ?>: <?php echo e($sales->customer->name); ?><br />
            <?php if(!empty($sales->customer->address)): ?>
            <?php echo e(trans('sale.address')); ?>: <?php echo e($sales->customer->address); ?><br />
            <?php endif; ?>
            <?php echo e(trans('sale.sale_id')); ?>: SAL-INV-<?php echo e($sales->id); ?><br />
        </div>
        <div class="col-md-5 col-sm-5 col-xs-6 text-right">
            Date : <?php echo e(Carbon\Carbon::now()); ?><br>
            <?php if(!empty($sales->customer->phone_number)): ?>
            <?php echo e(trans('sale.mobile')); ?> : <?php echo e($sales->customer->phone_number); ?><br>
            <?php endif; ?>
            <?php echo e(trans('sale.employee')); ?>: <?php echo e($sales->user->name); ?><br />
        </div>
    </div>
    <div class="row"></div>
    <div class="row">
        <div class="col-md-12 col-sm-12 col-xs-12">
            <div class="table-responsive font-size-15">
                <table class="table table-bordered">
                    <thead>
                        <tr>
                            <th><?php echo e(trans('sale.item')); ?></th>
                            <th><?php echo e(trans('sale.price')); ?></th>
                            <th><?php echo e(trans('sale.qty')); ?></th>
                            <th align="right"><?php echo e(trans('sale.total')); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                    <?php $__currentLoopData = $saleItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($value->item->item_name); ?></td>
                            <td><?php echo e($value->selling_price); ?></td>
                            <td><?php echo e($value->quantity); ?></td>
                            <td align="right"><?php echo e($value->total_selling); ?></td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    <div class="row bottom_border print_footer font-size-15">
        <div class="col-md-7 col-sm-7 col-xs-6">
            <?php echo e(trans('sale.payment_type')); ?>: <?php echo e($sales->payment_type); ?>

        </div>
        <div class="col-md-2 col-sm-1"></div>
        <div class="col-md-3 col-sm-4 col-xs-6">
            <div class="row invoice-footer">
                <div class="col-xs-5"><?php echo e(__('Subtotal')); ?>: </div><div class="col-xs-7"> <span class="text-left"><?php echo e(currencySymbol()); ?></span><span class="pull-right"> <?php echo e($sales->discount + $sales->grand_total - $sales->tax); ?></span></div>
                <div class="col-xs-5"><?php echo e(__('Discount')); ?>: </div>
                <div class="col-xs-7"> 
                    <span class="text-left"> <?php echo e(currencySymbol()); ?></span><span class="pull-right"> <?php echo e($sales->discount); ?></span>
                </div>
                <div class="col-xs-5"><?php echo e(__('Payment')); ?>: </div>
                <div class="col-xs-7"> 
                    <span class="text-left"> <?php echo e(currencySymbol()); ?></span><span class="pull-right"> <?php echo e($sales->payment); ?></span>
                </div>
                <div class="col-xs-5"><?php echo e(__('Tax')); ?>: </div><div class="col-xs-7"> <span class="text-left"><?php echo e(currencySymbol()); ?></span><span class="pull-right"> <?php echo e($sales->tax); ?></span></div>
                <div class="col-xs-5"><?php echo e(__('Dues')); ?>: </div><div class="col-xs-7"> <span class="text-left"><?php echo e(currencySymbol()); ?></span><span class="pull-right"> <?php echo e($sales->dues); ?></span></div>
            </div>
        </div>
    </div>
    <hr class="hidden-print"/>
    <div class="row">
        <div class="col-md-6">
            &nbsp;
        </div>
        <div class="col-md-2 col-4">
            <button type="button" onclick="printInvoice()" class="btn btn-info pull-right hidden-print"><?php echo e(trans('sale.print')); ?></button>
        </div>
        <div class="col-md-2 col-4">
            <a href="<?php echo e(url('/sales/create')); ?>" type="button" class="btn btn-info pull-right hidden-print"><?php echo e(trans('sale.new_sale')); ?></a>
        </div>
        <div class="col-md-2 col-4">
            <a href="javascript:;" data-ajax-url="<?php echo e(route('sale.mail-invoice', $sales->id)); ?>" type="button" class="btn btn-info pull-right hidden-print"><?php echo e(__('Email Invoice')); ?></a>
        </div>
    </div>
</section><?php /**PATH /Users/ajitdas/prjs-mega/flexiblepos-v2.0/resources/views/sale/print_invoice.blade.php ENDPATH**/ ?>