<?php $__env->startSection('content'); ?>
<div class="login-background"></div>
<div class="login-box">
  <div class="login-logo">
    <a href="#">
<?php if(!empty(setting('logo_path'))): ?>
        <img src="<?php echo e(asset(setting('logo_path'))); ?>" alt="" height="70px">
        <?php else: ?>
        <img src="<?php echo e(asset('images/fpos.png')); ?>" alt="" height="70px">
        <?php endif; ?>

    </a>
  </div>
  <!-- /.login-logo -->
  <div class="login-box-body">
  <p class="login-box-msg"><?php echo e(__('Sign in to start your session')); ?></p>
	<?php if(count($errors) > 0): ?>
		<div class="alert alert-danger">
		<strong>Whoops!</strong> <?php echo e(__('There were some problems with your input.')); ?><br><br>
			<ul>
				<?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
					<li><?php echo e($error); ?></li>
				<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
			</ul>
		</div>
	<?php endif; ?>
    <form data-no-ajax action="<?php echo e(route('login')); ?>" method="post" id="login_form">
      <?php echo csrf_field(); ?>
      <div class="form-group has-feedback">
        <input type="email" id="email" class="form-control" name="email" value="<?php echo e(old('email')); ?>" placeholder="Email">
        <span class="glyphicon glyphicon-envelope form-control-feedback"></span>
      </div>
      <div class="form-group has-feedback">
        <input type="password" id="password" class="form-control" name="password" placeholder="Password">
        <span class="glyphicon glyphicon-lock form-control-feedback"></span>
      </div>
      <div class="row">
        <div class="col-xs-8">
          <div class="checkbox icheck">
            <label>
              <input type="checkbox"> <?php echo e(__('Remember Me')); ?>

            </label>
          </div>
        </div>
        <!-- /.col -->
        <div class="col-xs-4">
		<button type="submit" submit-text="Loading..." class="btn btn-success btn-block"><?php echo e(__('Sign In')); ?></button>
        </div>
        <!-- /.col -->
      </div>
    </form>
    <div class="social-auth-links text-center">

    </div>
    <!-- /.social-auth-links -->

	<a href="<?php echo e(route('password.request')); ?>"><?php echo e(__('I forgot my password')); ?></a><br>
  </div>
  <!-- /.login-box-body -->
</div>
<?php if(config('fpos.demo')): ?>
<div class="login-box">
  <div class="text-center">
    <a href="javascript:;" class="btn btn-success" onclick="onClickLogin('admin@flexibleit.net', 'login_form')"><b>Admin:</b> <b>User:</b> admin@flexibleit.net <b>Pass:</b> password</a>
    <a href="javascript:;" class="btn btn-primary" onclick="onClickLogin('salesman@flexibleit.net', 'login_form')"><b>Salesman:</b> <b>User:</b> salesman@flexibleit.net <b>Pass:</b> password</a>
    <a href="javascript:;" class="btn btn-info" onclick="onClickLogin('account@flexibleit.net', 'login_form')"><b>Account:</b> <b>User:</b> account@flexibleit.net <b>Pass:</b> password</a>
  </div>
</div>
<?php endif; ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
<script src="<?php echo e(asset('dist/js/icheck.min.js')); ?>"></script>
<script>
  $(function () {
    $('input').iCheck({
      checkboxClass: 'icheckbox_square-blue',
      radioClass: 'iradio_square-blue',
      increaseArea: '20%' /* optional */
    });
  });

  function onClickLogin(email, formid) {
    
    $("#email").val(email);
    $("#password").val('password');
    $("#loginSubmit").text('Loading...');
    $("#"+formid).submit();
  }
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.front', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/ajitdas/prjs-mega/flexibleps-5.6/resources/views/auth/login.blade.php ENDPATH**/ ?>