<div id="expenseTable">
<?php if(!empty($expenses)): ?>
<table id="myTableExpense" class="table table-bordered table-hover table-striped table-responsive">
    <thead>
        <tr>
            <th><?php echo e(__('Created at')); ?></th>
            <th class="hidden-xs"><?php echo e(__('Qty')); ?></th>
            <th class="hidden-xs"><?php echo e(__('Unit Price')); ?></th>
            <th><?php echo e(__('Total')); ?></th>
            <th><?php echo e(__('Payment')); ?></th>
            <th class="hidden-xs"><?php echo e(__('Dues')); ?></th>
            <th class="hidden-xs"><?php echo e(__('Category')); ?></th>
            <th width="50" class="hidden-xs"><?php echo e(__('Type')); ?></th>
            <th class="hidden-xs"><?php echo e(__('Created By')); ?></th>
            <th class="text-center"><?php echo e(__('Action')); ?></th>
        </tr>
    </thead>
    <tbody>
      <?php $__currentLoopData = $expenses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
      <tr>
        <td><?php echo e($value->created_at->format('d M, Y')); ?></td>
        <td class="hidden-xs"><?php echo e($value->qty); ?></td>
        <td class="hidden-xs"><?php echo e($value->unit_price); ?></td>
        <td><?php echo e($value->total); ?></td>
        <td><?php echo e($value->payment); ?></td>
        <td class="hidden-xs"><?php echo e($value->dues); ?></td>
        <td class="hidden-xs"><?php echo e($value->expense_category->name); ?></td>
        <td class="hidden-xs"><?php echo e($value->payment_type); ?></td>
        <td class="hidden-xs"><?php echo e($value->user->name); ?></td>
        <td class="item_btn_group">
            
            <?php
            $actions = [
              ['data-replace'=>'#editExpense','url'=>'#editExpenseModal','ajax-url'=>url('expense/'.$value->id.'/edit'), 'name'=>trans('item.edit'), 'icon'=>'pencil'],
              ['url'=>'expense/' . $value->id,'name'=>'delete']];
            ?>
            <?php echo $__env->make('partials.actions', ['actions'=>$actions], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </td>
      </tr>
      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
  </tbody>
</table>
<?php echo $__env->make('partials.pagination', ['items'=>$expenses, 'index_route'=>$index_route], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php endif; ?>

</div><?php /**PATH /Users/ajitdas/prjs-mega/flexiblepos-v2.0/resources/views/expense/partials/expense_table.blade.php ENDPATH**/ ?>