<?php if(!empty($supplier)): ?>
<div class="modal-content" id="editSupplier">
    <?php echo e(Form::model($supplier, array('route' => array('suppliers.update', $supplier->id), 'method' => 'PUT', 'files' => true))); ?>

<?php else: ?>
<div class="modal-content" id="addSupplier">
    <?php echo e(Form::open(array('url' => 'suppliers', 'files' => true))); ?>

<?php endif; ?>
<div class="modal-header">
    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
    <h4 class="modal-title"><?php if(!empty($supplier)): ?> <?php echo e(__('Edit Supplier')); ?> <?php else: ?> <?php echo e(__('Add Supplier')); ?><?php endif; ?></h4>
</div>
<div class="modal-body" >
    <div class="row">
        <div class="col-md-6"> 
            <div class="form-group row">
                <?php echo e(Form::label('company_name', trans('supplier.company_name').' *', ['class'=> 'col-sm-4 text-right'])); ?>

                <div class="col-sm-8">
                <?php echo e(Form::text('company_name', Null, array('class' => 'form-control', 'required'))); ?>

                </div>
            </div>

            <div class="form-group row">
                <?php echo e(Form::label('name', trans('supplier.name').' *', ['class'=> 'col-sm-4 text-right'])); ?>

                <div class="col-sm-8">
                <?php echo e(Form::text('name', Null, array('class' => 'form-control'))); ?>

                </div>
            </div>

            <div class="form-group row">
                <?php echo e(Form::label('email', trans('supplier.email'), ['class'=> 'col-sm-4 text-right'])); ?>

                <div class="col-sm-8">
                <?php echo e(Form::text('email', Null, array('class' => 'form-control'))); ?>

                </div>
            </div>

            <div class="form-group row">
                <?php echo e(Form::label('phone_number', trans('supplier.phone_number'), ['class'=> 'col-sm-4 text-right'])); ?>

                <div class="col-sm-8">
                <?php echo e(Form::text('phone_number', Null, array('class' => 'form-control'))); ?>

                </div>
            </div>

            <div class="form-group row">
                <?php echo e(Form::label('address', trans('supplier.address'), ['class'=> 'col-sm-4 text-right'])); ?>

                <div class="col-sm-8">
                <?php echo e(Form::text('address', Null, array('class' => 'form-control'))); ?>

                </div>
            </div>
            <div class="form-group row">
                <?php echo e(Form::label('city', trans('supplier.city'), ['class'=> 'col-sm-4 text-right'])); ?>

                <div class="col-sm-8">
                <?php echo e(Form::text('city', Null, array('class' => 'form-control'))); ?>

                </div>
            </div>
            <div class="form-group hidden-xs row">
                <?php echo e(Form::label('state', trans('supplier.state'), ['class'=> 'col-sm-4 text-right'])); ?>

                <div class="col-sm-8">
                <?php echo e(Form::text('state', Null, array('class' => 'form-control'))); ?>

                </div>
            </div>
        </div>
        <div class="col-md-6">
            <div class="form-group hidden-xs row">
                <?php echo e(Form::label('zip', trans('supplier.zip'), ['class'=> 'col-sm-4 text-right'])); ?>

                <div class="col-sm-8">
                <?php echo e(Form::text('zip', Null, array('class' => 'form-control'))); ?>

                </div>
            </div>
            <div class="form-group hidden-xs row">
                <?php echo e(Form::label('comments', trans('supplier.comments'), ['class'=> 'col-sm-4 text-right'])); ?>

                <div class="col-sm-8">
                <?php echo e(Form::text('comments', Null, array('class' => 'form-control'))); ?>

                </div>
            </div>
            <div class="form-group row">
                <?php echo e(Form::label('account', trans('supplier.account').' #', ['class'=> 'col-sm-4 text-right'])); ?>

                <div class="col-sm-8">
                <?php echo e(Form::text('account', Null, array('class' => 'form-control'))); ?>

                </div>
            </div>
            <div class="form-group row">
                <?php echo e(Form::label('prev_balance', trans('supplier.prev_balance'),['class'=>'col-sm-4 text-right'])); ?>

                <div class="col-sm-8">
                    <?php if(isset($supplier)): ?>
                <?php echo e(Form::number('prev_balance', null, ['class' => 'form-control'])); ?>

                    <?php else: ?>
                <?php echo e(Form::number('prev_balance', 0, ['class' => 'form-control'])); ?>

                        <?php endif; ?>
                </div>
            </div>
            <div class="form-group row">
                <?php echo e(Form::label('payment', trans('supplier.payment') ,['class'=>'col-sm-4 text-right'])); ?>

                <div class="col-sm-8">
                    <?php if(!empty($supplier)): ?>
                <?php echo e(Form::number('payment', null, ['class' => 'form-control', 'readonly'=>''])); ?>

                    <?php else: ?>
                <?php echo e(Form::number('payment', 0, ['class' => 'form-control'])); ?>

                        <?php endif; ?>
                </div>
            </div>
            <div class="form-group row">
            <?php echo e(Form::label('avatar', trans('supplier.choose_avatar'), ['class'=> 'col-sm-4 text-right'])); ?>

            <div class="col-sm-8">
            <?php echo e(Form::file('avatar', Null, array('class' => 'form-control'))); ?>

                <?php if(!empty($supplier->avatar)): ?>
                <img src="<?php echo e($supplier->fileUrl()); ?>" alt="" height="35">
                <?php endif; ?>
            </div>
            </div>
        </div>
    </div>
</div>
<div class="modal-footer">
    <?php if(!empty($page)): ?>
    <input type="hidden" name="page" value="<?php echo e($page); ?>">
    <?php endif; ?>
    <?php echo e(Form::submit(trans('supplier.submit'), array('class' => 'btn btn-success'))); ?>

    <button type="button" class="btn btn-default" data-dismiss="modal"><?php echo e(__('Close')); ?></button>
</div>
<?php echo e(Form::close()); ?>

</div><?php /**PATH /Users/ajitdas/prjs-mega/flexiblepos-v2.0/resources/views/supplier/form.blade.php ENDPATH**/ ?>