<?php if(!empty($item)): ?>
<div class="modal-content" id="editItem">
        <?php echo e(Form::model($item, array('route' => array('items.update', $item->id), 'method' => 'PUT', 'files' => true))); ?>

<?php else: ?>
<div class="modal-content" id="addItem">
    <?php echo e(Form::open(['url' => 'items', 'files' => true])); ?>

<?php endif; ?>
    <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
        <h4 class="modal-title"><?php if(!empty($item)): ?> <?php echo e(__('Edit Item')); ?> <?php else: ?> <?php echo e(__('Add Item')); ?><?php endif; ?></h4>
    </div>
    <div class="modal-body" >
        <div class="row">
            <div class="col-md-6">

                <?php echo $__env->make('item.add_category_btn', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                <div class="form-group row">
                <?php echo e(Form::label('upc_ean_isbn', __('SKU').' *', ['class'=>'col-sm-3 text-right'])); ?>

                    <div class="col-sm-9"> 
                    <?php echo e(Form::text('upc_ean_isbn',null, ['class' => 'form-control', 'required'])); ?>

                    </div>
                </div>

                <div class="form-group row">
                <?php echo e(Form::label('item_name', trans('item.item_name').' *', ['class'=>'col-sm-3 text-right'])); ?>

                    <div class="col-sm-9">
                    <?php echo e(Form::text('item_name', null, ['class' => 'form-control','required'])); ?>

                    </div>
                </div>

                <div class="form-group row">
                <?php echo e(Form::label('size', trans('item.size'), ['class'=>'col-sm-3 text-right'])); ?>

                <div class="col-sm-9"> 
                <?php echo e(Form::text('size', null, ['class' => 'form-control'])); ?>

                </div>
                </div>

                <div class="form-group row">
                <?php echo e(Form::label('description', trans('item.description'), ['class'=>'col-sm-3 text-right'])); ?>

                <div class="col-sm-9"> 
                <?php echo e(Form::textarea('description', null, ['class' => 'form-control', 'rows'=>4])); ?>

                </div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="form-group row">
                        <?php echo e(Form::label('hasVariant', trans('item.HasVariant'), ['class'=>'col-sm-3 text-right'])); ?>

                        <div class="col-sm-9"> 
                        <input type="checkbox" id="hasVariant" name="hasVariant" value="hasVarient" onclick="hideField()">
                        </div>
                </div>
                <div class="form-group row">
                    <?php echo e(Form::label('cost_price', trans('item.cost_price').' *', ['class'=>'col-sm-3 text-right'])); ?>

                    <div class="col-sm-9"> 
                    <?php echo e(Form::text('cost_price', null, ['class' => 'form-control', 'required'])); ?>

                    </div>
                </div>

                <div class="form-group row">
                    <?php echo e(Form::label('selling_price', __('Sell Price').' *', ['class'=>'col-sm-3 text-right'])); ?>

                    <div class="col-sm-9"> 
                    <?php echo e(Form::text('selling_price', null, ['class' => 'form-control', 'required'])); ?>

                    </div>
                </div>

                <div class="form-group row" id="quantity">
                    <?php echo e(Form::label('quantity', trans('item.quantity'), ['class'=>'col-sm-3 text-right'])); ?>

                    <div class="col-sm-9"> 
                    <?php echo e(Form::text('quantity', null, ['class' => 'form-control'])); ?>

                    </div>
                </div>
                <div class="form-group row">
                    <?php echo e(Form::label('stock_limit', __('Stock Limit'), ['class'=>'col-sm-3 text-right'])); ?>

                    <div class="col-sm-9"> 
                    <?php echo e(Form::number('stock_limit', null, ['class' => 'form-control'])); ?>

                    </div>
                </div>
                <div class="form-group row" id="exp_date">
                    <?php echo e(Form::label('expire_date', __('Expire Date'), ['class'=>'col-sm-3 text-right'])); ?>

                    <div class="col-sm-9"> 
                    <?php echo e(Form::date('expire_date', null, ['class' => 'form-control'])); ?>

                    </div>
                </div>
                <div class="form-group row">
                    <?php echo e(Form::label('avatar', __('Avatar'), ['class'=>'col-sm-3 text-right'])); ?>

                    <div class="col-sm-9">
                        <?php echo e(Form::file('avatar', null, ['class' => 'form-control'])); ?>

                        <?php if(!empty($item)): ?>
                        <img src="<?php echo e($item->fileUrl()); ?>" alt="" height="35">
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="modal-footer">
        <?php echo e(Form::submit(trans('item.submit'), ['class' => 'btn btn-success'])); ?>

        <button type="button" class="btn btn-default" data-dismiss="modal"><?php echo e(__('Close')); ?></button>
    </div>    
    <?php echo e(Form::close()); ?>

</div><?php /**PATH /Users/ajitdas/prjs-mega/flexiblepos-v2.0/resources/views/item/form.blade.php ENDPATH**/ ?>